/*:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::
::   Module      :   Boot Interface definition for MPC5xx processor familiy
::   Copyright   :   (C)2002-2009 Woodward
::   Platform(s) :   MPC5xx
::   Limitations :   None
::
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::*/
/*! \internal
    \file  BootInterface_MPC5xx.h

*/
#ifndef __BOOTINTERFACE_MPC5XX_H
#define __BOOTINTERFACE_MPC5XX_H

/*---- INCLUDE FILES --------------------------------------------------------------------------------------*/

/* Default to 565 */
#ifndef __TARGET_PROCESSOR
#warning __TARGET_PROCESSOR not defined.  Defaulting to MPC565_TARGET.
#define __TARGET_PROCESSOR MPC565_TARGET
#endif

/* Include this after, as it looks at __TARGET_PROCESSOR */
#include <MPC5xx.h>


/*---- DEFINES --------------------------------------------------------------------------------------------*/

#if ((__TARGET_PROCESSOR == MPC565_TARGET) || \
     (__TARGET_PROCESSOR == MPC563_TARGET))

    /*! \brief Macro to return a pointer to an array of Module Configuration Pointers */
    #define GetModuleConfigPointerArr()       ((BASEPTRARR)0x500)
    /*! \brief Macro to return a pointer to an array of Hardware BootStrap Pointers */
    #define GetHardwareBootStrapPointerArr()  ((BASEPTRARR)0x4100)
    /*! \brief Macro to return a pointer to an array of Hardware BootStrap Pointers */
    #define GetSoftwareBootStrapPointerArr()  ((BASEPTRARR)0x3F8040)
    /*! \brief Macro to return a pointer to the boot mail box */
    #define GetBootMailBox()                  ((S_BootMailBox*)0x3fffb0)
#elif (__TARGET_PROCESSOR == MPC555_TARGET)
    /*! \brief Macro to return a pointer to an array of Module Configuration Pointers */
    #define GetModuleConfigPointerArr()       ((BASEPTRARR)0x500)
    /*! \brief Macro to return a pointer to an array of Hardware BootStrap Pointers. Is \c NULL if the
               build does not support HardwareBootStrapPointers */
    #define GetHardwareBootStrapPointerArr()  ((BASEPTRARR)0x0600)
    /*! \brief Macro to return a pointer to the boot mail box */
    #define GetBootMailBox()                  ((S_BootMailBox*)0x3fffb0)
#endif

/*---- TYPEDEF --------------------------------------------------------------------------------------------*/

/*---- FUNCTION PROTOTYPES --------------------------------------------------------------------------------*/

#endif /* __BOOTINTERFACE_MPC5XX_H */


/*---- END OF FILE ----------------------------------------------------------------------------------------*/

